//	TorusGamesWindowController.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import "GeometryGamesWindowController.h"
#import "TorusGames-Common.h"


@interface TorusGamesWindowController : GeometryGamesWindowController

- (id)initWithDelegate:(id<GeometryGamesWindowControllerDelegate>)aDelegate;
- (void)createSubviews;
- (void)handlePossibleGPUChangeNotification:(NSNotification *)aNotification;
- (void)windowWillClose:(NSNotification *)aNotification;

- (NSRect)windowWillUseStandardFrame:(NSWindow *)window defaultFrame:(NSRect)newFrame;
- (void)windowDidResize:(NSNotification *)aNotification;

- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;
- (void)commandHumanVsComputer:(id)sender;
- (void)commandDifficultyLevel:(id)sender;
- (void)commandGlideReflections:(id)sender;
- (void)commandSaveImageRGB:(id)sender;
- (void)commandSaveImageRGBA:(id)sender;
- (void)commandTopology:(id)sender;
- (void)commandView:(id)sender;
- (void)commandPracticeBoard:(id)sender;

- (void)languageDidChange;
- (void)changeGame:(GameType)aNewGame;
- (void)setTorusGamesStatusMessage:(NSString *)aText color:(ColorP3Linear)aColorP3Linear;

- (void)mouseMoved:(NSEvent *)anEvent;

@end
